/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtKnx module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QKNXNETIPKNXADDRESSESDIB_H
#define QKNXNETIPKNXADDRESSESDIB_H

#include <QtKnx/qknxaddress.h>
#include <QtKnx/qtknxglobal.h>
#include <QtKnx/qknxnetipstruct.h>

QT_BEGIN_NAMESPACE

class Q_KNX_EXPORT QKnxNetIpKnxAddressesDibProxy final
{
public:
    QKnxNetIpKnxAddressesDibProxy() = delete;
    ~QKnxNetIpKnxAddressesDibProxy() = default;

    QKnxNetIpKnxAddressesDibProxy(const QKnxNetIpDib &&) = delete;
    explicit QKnxNetIpKnxAddressesDibProxy(const QKnxNetIpDib &dib);

    bool isValid() const;

    QKnxNetIp::DescriptionType descriptionType() const;
    QVector<QKnxAddress> individualAddresses() const;

    class Q_KNX_EXPORT Builder final
    {
    public:
        Builder &setIndividualAddresses(const QVector<QKnxAddress> &addresses);
        QKnxNetIpDib create() const;

    private:
        QVector<QKnxAddress> m_addresses;
    };
    static QKnxNetIpKnxAddressesDibProxy::Builder builder();

private:
    const QKnxNetIpDib &m_dib;
};

QT_END_NAMESPACE

#endif
